/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.system.util;

import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.service.system.util.UnsupportedDTDException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ServiceInterfacesParser
extends DOMParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XRVF063T";
    private static final String TRACE_MASKF = "XRVF063F";
    private static final String TRACE_MASKD = "XRVF063D";
    private static final String TAG_SERVICE_INTERFACES = "service-interfaces";
    private static final String TAG_KEY = "key";
    private static final String TAG_FACTORY = "factory";
    private static final String TAG_FACTORIES = "factories";
    private static final String TAG_IMPL = "impl";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_SINGLETON = "singleton";
    private KeyNode root = null;
    private Map unkeyedFactories = null;

    public ServiceInterfacesParser() {
        try {
            this.setFeature("http://xml.org/sax/features/validation", true);
            this.setErrorHandler(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseFile(File file) throws ServiceInterfacesException {
        try {
            ServiceInterfacesParser parser = new ServiceInterfacesParser();
            parser.parse(new InputSource(new FileInputStream(file)));
            Document doc = parser.getDocument();
            if (!doc.getDoctype().getName().equals(TAG_SERVICE_INTERFACES)) {
                throw new UnsupportedDTDException("unsupported DTD; file[" + file.getName() + "], DTD[" + doc.getDoctype().getName() + "]");
            }
            NodeList nodeList = doc.getElementsByTagName(TAG_SERVICE_INTERFACES);
            KeyNode newTree = new KeyNode();
            this.parseKeys(newTree, nodeList.item(0));
            if (this.root == null) {
                this.root = newTree;
            } else {
                this.testOverlap(this.root, newTree);
                Iterator it = newTree.iterator();
                while (it.hasNext()) {
                    this.root.add(it.next());
                }
            }
        }
        catch (IOException e) {
            throw new ServiceInterfacesException("IOException reading file");
        }
        catch (SAXException e) {
            throw new ServiceInterfacesException("SaxException! " + e);
        }
    }

    private void parseKeys(KeyNode parent, Node nodeToParse) throws ServiceInterfacesException {
        NodeList nodeList = nodeToParse.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node domNode = nodeList.item(i);
            if (!domNode.getNodeName().toLowerCase().equals(TAG_KEY)) continue;
            KeyNode keyNode = new KeyNode();
            this.parseKeys(keyNode, domNode);
            Node name = domNode.getAttributes().getNamedItem(ATTRIB_NAME);
            String className = name.getNodeValue();
            try {
                keyNode.keyClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.parseKeys ClassNotFoundException caught, bailing: " + e);
                Trace.trace(TRACE_MASKT, e);
                throw new ServiceInterfacesException(e);
            }
            this.parseFactories(keyNode, domNode);
            parent.add(keyNode);
            keyNode.parent = parent;
        }
    }

    private void parseFactories(KeyNode keyNode, Node nodeToParse) throws ServiceInterfacesException {
        NodeList nodeList = nodeToParse.getChildNodes();
        for (int aii = 0; aii < nodeList.getLength(); ++aii) {
            Node domNode = nodeList.item(aii);
            if (!domNode.getNodeName().toLowerCase().equals(TAG_FACTORIES)) continue;
            NodeList subList = domNode.getChildNodes();
            for (int bii = 0; bii < subList.getLength(); ++bii) {
                Node subNode = subList.item(bii);
                if (subNode.getNodeType() != 1) continue;
                if (subNode.getNodeName().toLowerCase().equals(TAG_FACTORY)) {
                    FactoryMapping fm = this.parseFactory(subNode);
                    if (fm == null) continue;
                    keyNode.factories.put(fm.ifaceName, fm);
                    continue;
                }
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.parseFactories only the factory tag is supported under factories; found " + subNode.getNodeName());
                throw new ServiceInterfacesException("only the factory tag is supported under factories; found " + subNode.getNodeName());
            }
        }
    }

    private FactoryMapping parseFactory(Node domNode) throws ServiceInterfacesException {
        FactoryMapping factoryMapping = new FactoryMapping();
        if (domNode.getNodeName().toLowerCase().equals(TAG_FACTORY)) {
            Node singleton;
            Node name = domNode.getAttributes().getNamedItem(ATTRIB_NAME);
            if (name == null || name.getNodeType() != 2) {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.parseFactory Unable to locate name attribute on <" + domNode + "> entry");
                throw new ServiceInterfacesException("Unable to locate name attribute on <" + domNode + "> entry");
            }
            factoryMapping.ifaceName = name.getNodeValue();
            if (domNode.getNodeType() == 1) {
                NodeList implList = domNode.getChildNodes();
                for (int aii = 0; aii < implList.getLength(); ++aii) {
                    Node impl = implList.item(aii);
                    if (!impl.getNodeName().toLowerCase().equals(TAG_IMPL)) continue;
                    factoryMapping.implName = this.gatherTextContents(impl);
                }
            }
            if ((singleton = domNode.getAttributes().getNamedItem(ATTRIB_SINGLETON)) != null && singleton.getNodeValue().toLowerCase().equals("false")) {
                factoryMapping.singleton = false;
            }
        } else {
            Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.parseFactory parseFactory called for non-factory domNode[" + domNode + "]");
            throw new ServiceInterfacesException("parseFactory called for non-factory domNode[" + domNode + "]");
        }
        return factoryMapping;
    }

    private String gatherTextContents(Node domNode) throws ServiceInterfacesException {
        StringBuffer sb = new StringBuffer(128);
        NodeList children = domNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            if (child.getNodeType() != 3) {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.gatherTextContents Non TEXT_NODE found in inappropriate context");
                throw new ServiceInterfacesException("Non TEXT_NODE found in inappropriate context");
            }
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public Object getFactory(String key, String factoryInterface) throws ServiceInterfacesException {
        Iterator it = this.root.iterator();
        try {
            Class<?> keyClass = Class.forName(key);
            KeyNode top = null;
            KeyNode bottom = null;
            KeyNode current = null;
            while (it.hasNext()) {
                current = (KeyNode)it.next();
                if (!current.keyClass.isAssignableFrom(keyClass)) continue;
                bottom = current;
                if (top == null) {
                    top = current;
                }
                it = current.iterator();
            }
            if (top == null) {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.getFactory class key or superclass not found[" + key + "]");
                throw new ServiceInterfacesException("class key or superclass not found[" + key + "]");
            }
            current = bottom;
            while (current != null) {
                if (current.factories.containsKey(factoryInterface)) {
                    FactoryMapping fm = (FactoryMapping)current.factories.get(factoryInterface);
                    if (!fm.singleton) {
                        return this.constructObject(fm.implName);
                    }
                    if (fm.instance == null) {
                        fm.instance = this.constructObject(fm.implName);
                        return fm.instance;
                    }
                    return fm.instance;
                }
                current = current.parent;
            }
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.getFactory class key or superclass not found[" + key + "]");
            throw new ServiceInterfacesException(e);
        }
        Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.getFactory factory interface[" + factoryInterface + "] not defined in key class heirarchy[" + key + "]");
        throw new ServiceInterfacesException("factory interface[" + factoryInterface + "] not defined in key class heirarchy[" + key + "]");
    }

    private Object constructObject(String className) throws ServiceInterfacesException {
        try {
            Object theImpl = null;
            Class<?> implClass = Class.forName(className);
            Constructor<?>[] constructors = implClass.getConstructors();
            if (constructors.length > 0) {
                Constructor<?> theOne = null;
                for (int i = 0; i < constructors.length && theOne == null; ++i) {
                    if (constructors[i].getParameterTypes().length != 0) continue;
                    theOne = constructors[i];
                }
                if (theOne == null) {
                    Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.constructObject default factory constructor available for class[" + className + "]");
                    throw new ServiceInterfacesException("default factory constructor available for class[" + className + "]");
                }
            } else {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.constructObject No Public constructors available.");
                throw new ServiceInterfacesException("No Public constructors available.");
            }
            theImpl = implClass.newInstance();
            return theImpl;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.constructObject InvocationTargetException: '" + className + "'");
            throw new ServiceInterfacesException("InvocationTargetException: '" + className + "'");
        }
    }

    public void warning(SAXParseException saxPE) {
    }

    public void error(SAXParseException saxPE) throws SAXException {
        throw saxPE;
    }

    public void fatalError(SAXParseException saxPE) throws SAXException {
        throw saxPE;
    }

    private String where(SAXParseException saxPE) {
        return (saxPE.getSystemId() != null ? saxPE.getSystemId() : "") + ":line=" + saxPE.getLineNumber() + ":col=" + saxPE.getColumnNumber() + "  " + saxPE.getMessage();
    }

    private void dumpTree(KeyNode keyNode) {
        Iterator it = keyNode.iterator();
        while (it.hasNext()) {
            this.dumpTree((KeyNode)it.next());
        }
        String ch = "";
        KeyNode node = keyNode;
        while (node != null) {
            ch = ch + "[" + node.keyClass + "]";
            node = node.parent;
        }
        Trace.trace(TRACE_MASKD, "ServiceInterfacesParser.dumpTree - " + ch);
    }

    private void testOverlap(KeyNode root1, KeyNode root2) throws ServiceInterfacesException {
        Iterator it1 = root1.iterator();
        Iterator it2 = root2.iterator();
        for (int count = 0; count < 2; ++count) {
            while (it1.hasNext()) {
                KeyNode rootElement = (KeyNode)it1.next();
                while (it2.hasNext()) {
                    KeyNode newElement = (KeyNode)it2.next();
                    if (!rootElement.keyClass.isAssignableFrom(newElement.keyClass)) continue;
                    Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.testOverlap Key class heirarchy conflict [" + rootElement.keyClass + "] isAssignableFrom [" + newElement.keyClass + "]");
                    throw new ServiceInterfacesException("Key class heirarchy conflict [" + rootElement.keyClass + "] isAssignableFrom [" + newElement.keyClass + "]");
                }
            }
            it1 = root2.iterator();
            it2 = root1.iterator();
        }
    }

    public void parseUnkeyedFactories(Node nodeToParse) throws ServiceInterfacesException {
        if (nodeToParse.getNodeName().toLowerCase().equals(TAG_FACTORIES)) {
            this.unkeyedFactories = new HashMap();
            NodeList factoryTags = nodeToParse.getChildNodes();
            for (int aii = 0; aii < factoryTags.getLength(); ++aii) {
                Node factoryTag = factoryTags.item(aii);
                if (factoryTag.getNodeType() != 1) continue;
                if (factoryTag.getNodeName().toLowerCase().equals(TAG_FACTORY)) {
                    FactoryMapping fm = this.parseFactory(factoryTag);
                    if (fm == null) continue;
                    this.unkeyedFactories.put(fm.ifaceName, fm);
                    continue;
                }
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.parseUnkeyedFactories only the factory tag is supported under factories; found " + factoryTag.getNodeName());
                throw new ServiceInterfacesException("only the factory tag is supported under factories; found " + factoryTag.getNodeName());
            }
        }
    }

    public Object getFactory(String factoryInterface) throws ServiceInterfacesException {
        try {
            FactoryMapping fm = (FactoryMapping)this.unkeyedFactories.get(factoryInterface);
            if (fm == null) {
                Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.getFactory factory interface[" + factoryInterface + "] not defined");
                throw new ServiceInterfacesException("factory interface[" + factoryInterface + "] not defined");
            }
            if (!fm.singleton) {
                return this.constructObject(fm.implName);
            }
            if (fm.instance == null) {
                fm.instance = this.constructObject(fm.implName);
                return fm.instance;
            }
            return fm.instance;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! ServiceInterfacesParser.getFactory Exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            if (!(e instanceof ServiceInterfacesException)) {
                throw new ServiceInterfacesException(e);
            }
            throw (ServiceInterfacesException)e;
        }
    }

    private static class KeyNode
    extends LinkedList {
        public KeyNode parent = null;
        public Map factories = new HashMap();
        public Class keyClass;
    }

    private static class FactoryMapping {
        public boolean singleton = true;
        public String implName = null;
        public String ifaceName = null;
        public Object instance = null;

        private FactoryMapping() {
        }
    }
}

